# 🏪 Textile POS System - Professional Edition

A complete, modern Point of Sale system specifically designed for textile businesses. Built with PHP, MySQL, Bootstrap, and JavaScript.

## ✨ **Features**

### 🛒 **Core POS Features**
- **Shopping Cart** - Add/remove items with real-time calculations
- **Barcode Scanning** - Scan products directly into cart
- **Receipt Printing** - Professional receipt generation
- **Payment Processing** - Cash & Card payment methods
- **Tax Calculation** - Automatic tax computation
- **Discount System** - Percentage-based discounts
- **Customer Selection** - Link sales to customers

### 📦 **Inventory Management**
- **Product Catalog** - Complete product management
- **Stock Tracking** - Real-time inventory updates
- **Low Stock Alerts** - Automatic reorder notifications  
- **Stock Adjustments** - Manual inventory corrections
- **Category Organization** - Product categorization
- **Barcode Support** - Unique barcodes for each product

### 👥 **Customer Management**
- **Customer Database** - Complete customer profiles
- **Purchase History** - Track customer transactions
- **Customer Analytics** - Purchase patterns & statistics
- **Contact Management** - Phone, email, address tracking

### 🚚 **Supplier Management** *(Professional)*
- **Supplier Directory** - Vendor contact management
- **Purchase Orders** - Create and track POs
- **Inventory Receiving** - Track incoming stock

### 👨‍💼 **User Management** *(Professional)*
- **Role-Based Access** - Admin, Manager, Cashier roles
- **User Authentication** - Secure login system
- **Activity Tracking** - User action logging
- **Permission Control** - Feature access by role

### 📊 **Reports & Analytics**
- **Sales Reports** - Daily, weekly, monthly sales
- **Top Products** - Best-selling item analysis
- **Revenue Tracking** - Financial performance metrics
- **Inventory Reports** - Stock level analysis
- **Customer Reports** - Customer purchase patterns
- **Export Functionality** - Excel/PDF export options

### ⚙️ **System Administration**
- **Admin Panel** - Complete system management
- **Database Backup** - Automated backup system
- **System Settings** - Configurable store settings
- **Activity Logs** - System usage tracking
- **Health Monitoring** - System status checks

## 🚀 **Installation**

### Prerequisites
- XAMPP (Apache, MySQL, PHP 7.4+)
- Web browser (Chrome, Firefox, Safari)

### Setup Steps

1. **Download & Extract**
   ```
   Extract to: C:\xampp\htdocs\trxtilepos
   ```

2. **Database Setup**
   ```sql
   -- Create database
   CREATE DATABASE textile_pos;
   
   -- Import complete schema with all features
   mysql -u root -p textile_pos < database_setup.sql
   ```

3. **Configure Database**
   ```php
   // Edit config.php
   $host = 'localhost';
   $db   = 'cwktwqbhbk_laknimpos';
   $user = 'root';
   $pass = 'Ravindu2001@';
   ```

4. **Start XAMPP**
   - Start Apache and MySQL services
   - Access: `http://localhost/trxtilepos`

5. **System Check**
   - Visit: `http://localhost/trxtilepos/setup_check.php`
   - Verify all components are working

## 🔐 **Default Login**

```
Username: admin
Password: admin123
Role: Administrator
```

## 📱 **Usage Guide**

### **Starting a Sale**
1. Go to POS Terminal
2. Scan barcode or search products
3. Add items to cart
4. Select customer (optional)
5. Apply discounts if needed
6. Choose payment method
7. Complete sale & print receipt

### **Managing Products**
1. Products → Add New Product
2. Enter product details (name, price, stock, barcode)
3. Set category and stock levels
4. Save product

### **Inventory Management**
1. Inventory → Stock Adjustment
2. Select product and adjustment amount
3. Enter reason for adjustment
4. Update stock levels

### **Customer Management**
1. Customers → Add New Customer
2. Enter customer information
3. View purchase history
4. Track customer analytics

### **Generating Reports**
1. Reports → Select date range
2. Choose report type
3. Export to Excel/PDF
4. Analyze business metrics

## 🛡️ **Security Features**

- **Password Hashing** - Secure password storage
- **Session Management** - Secure user sessions
- **Role-Based Access** - Permission-based features
- **SQL Injection Protection** - Prepared statements
- **Input Validation** - Data sanitization
- **CSRF Protection** - Cross-site request forgery prevention

## 🔧 **Technical Specifications**

### **Backend**
- **Language**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Architecture**: MVC Pattern
- **Security**: Password hashing, prepared statements

### **Frontend**
- **Framework**: Bootstrap 5.3
- **Icons**: Font Awesome 6.0
- **JavaScript**: Vanilla ES6+
- **Charts**: Chart.js
- **Responsive**: Mobile-first design

### **Database Schema**
- **Products** - Product catalog & inventory
- **Sales** - Transaction records
- **Sale Items** - Detailed line items
- **Customers** - Customer database
- **Users** - System users & roles
- **Suppliers** - Vendor management
- **Categories** - Product organization
- **Inventory Transactions** - Stock movement log

## 📊 **System Requirements**

### **Minimum**
- PHP 7.4+
- MySQL 5.7+
- 1GB RAM
- 500MB Storage

### **Recommended**
- PHP 8.0+
- MySQL 8.0+
- 4GB RAM
- 2GB Storage
- SSD Storage

## 🎯 **Professional Features**

### **Advanced POS**
- Multi-payment processing
- Split payments
- Layaway/hold orders
- Return processing
- Loyalty program integration

### **Business Intelligence**
- Sales forecasting
- Trend analysis
- Profit margin analysis
- ABC inventory analysis
- Seasonal reporting

### **Integration Ready**
- API endpoints
- Third-party integrations
- Accounting system sync
- E-commerce integration
- Mobile app ready

## 🆘 **Support & Troubleshooting**

### **Common Issues**

**Database Connection Error**
```php
// Check config.php credentials
// Verify MySQL service is running
// Ensure database exists
```

**Login Issues**
```php
// Use default: admin/admin123
// Check users table exists
// Verify password hashing
```

**Receipt Printing**
```javascript
// Enable popups in browser
// Check printer drivers
// Verify receipt template
```

## 📈 **Roadmap**

### **Upcoming Features**
- [ ] Mobile app (iOS/Android)
- [ ] Multi-store support
- [ ] Advanced reporting dashboard
- [ ] Inventory forecasting
- [ ] Automated reordering
- [ ] Integration with accounting software
- [ ] Customer loyalty program
- [ ] Email marketing integration

## 📄 **License**

This project is licensed under the MIT License - see the LICENSE file for details.

## 🤝 **Contributing**

1. Fork the repository
2. Create feature branch
3. Commit changes
4. Push to branch
5. Create pull request

## 📞 **Support**

For technical support or questions:
- Email: support@textilepos.com
- Documentation: [docs.textilepos.com]
- GitHub Issues: [Report bugs/issues]

---

**Textile POS System** - Powering textile businesses worldwide 🌍
