<?php
// barcode_generator.php
// Barcode generator and printing page for Textile POS

require_once 'vendor/autoload.php'; // For composer-based libraries
use Picqer\Barcode\BarcodeGeneratorPNG;


$product_name = '';
$price = '';
$barcode_text = '';
$barcode_image = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_name = $_POST['product_name'] ?? '';
    $price = $_POST['price'] ?? '';
    $barcode_text = $_POST['barcode_text'] ?? '';
    if ($barcode_text) {
    $generator = new BarcodeGeneratorPNG();
    // Use EAN13 if input is 12 or 13 digits, else fallback to CODE_128
    if (preg_match('/^\d{12,13}$/', $barcode_text)) {
        $barcode_type = $generator::TYPE_EAN_13;
        // EAN13 is more compact for numeric codes
        $barcode_raw = $generator->getBarcode($barcode_text, $barcode_type, 2.0, 18);
    } else {
        $barcode_type = $generator::TYPE_CODE_128;
        $barcode_raw = $generator->getBarcode($barcode_text, $barcode_type, 1.4, 18);
    }
    $barcode_image = base64_encode($barcode_raw);
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Barcode Generator - Textile POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container-fluid">
                <a class="navbar-brand fw-bold" href="#">Textile POS</a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="index.php">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" aria-current="page" href="#">Barcode Generator</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="products/products.php">Products</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="sales/sales.php">Sales</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">Logout</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <div class="container py-4">
        <h2 class="mb-4 text-center">Barcode Generator</h2>
        <form method="POST" class="card p-3 shadow-sm mb-4" style="max-width:400px;margin:auto;">
            <div class="mb-3">
                <label for="product_name" class="form-label">Product Name</label>
                <input type="text" name="product_name" id="product_name" class="form-control" value="<?php echo htmlspecialchars($product_name); ?>" required>
            </div>
            <div class="mb-3">
                <label for="price" class="form-label">Price</label>
                <input type="text" name="price" id="price" class="form-control" value="<?php echo htmlspecialchars($price); ?>" required>
            </div>
            <div class="mb-3">
                <label for="barcode_text" class="form-label">Barcode Text</label>
                <input type="text" name="barcode_text" id="barcode_text" class="form-control" value="<?php echo htmlspecialchars($barcode_text); ?>" required>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn btn-primary">Generate Barcode</button>
            </div>
        </form>
        <?php if ($barcode_image): ?>
            <div class="d-flex flex-column align-items-center justify-content-center mb-4">
                <div class="sticker-label shadow" id="barcodeSticker" style="margin-bottom:12px;">
                    <div class="sticker-title">DILRUKSHI TEX</div>
                    <img class="sticker-barcode-img" src="data:image/png;base64,<?= $barcode_image ?>" alt="Barcode">
                    <div class="sticker-barcode-num"><?= htmlspecialchars($barcode_text) ?></div>
                    <div class="sticker-product"><?= htmlspecialchars($product_name) ?></div>
                    <div class="sticker-price">Rs. <?= number_format($price, 2) ?></div>
                </div>
                <button onclick="printSticker()" class="btn btn-success px-4 py-2 fw-bold shadow">Print Sticker</button>
            </div>
            <style>
    @media print {
        @page {
            size: 38mm 25mm;
            margin: 0;
        }
        html, body {
            width: 38mm !important;
            height: 25mm !important;
            min-height: 0 !important;
            max-height: 25mm !important;
            margin: 0 !important;
            padding: 0 !important;
            background: #fff !important;
            overflow: hidden !important;
            box-sizing: border-box !important;
        }
    body * { visibility: hidden; }
    #barcodeSticker, #barcodeSticker * { visibility: visible !important; }
    #barcodeSticker {
            position: absolute;
            left: 0;
            top: 0;
            width: 38mm;
            height: 25mm;
            min-height: 0;
            max-height: 25mm;
            overflow: hidden;
        }
        button { display: none !important; }
    }
    /* Always show sticker preview in browser */
    .sticker-label {
        width: 38mm;
        height: 25mm;
        box-sizing: border-box;
        background: #fff;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: flex-start;
        min-height: 0;
    }
    .sticker-title {
        font-size: 2.5mm;
        font-weight: 700;
        letter-spacing: 0.1mm;
        margin: 0;
        text-transform: uppercase;
        flex-shrink: 1;
        font-family: 'Poppins', Arial, sans-serif;
    }
    .sticker-barcode-img {
        width: 23mm;
        height: 8mm;
        margin: 0;
        flex-shrink: 1;
    }
    .sticker-barcode-num {
        font-size: 2.5mm;
        margin: 0;
        flex-shrink: 1;
    }
    .sticker-product {
        font-size: 3mm;
        font-weight: 500;
        width: 100%;
        text-align: center;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        margin: 0;
        flex-shrink: 1;
    }
    .sticker-price {
        font-size: 2.8mm;
        font-weight: 700;
        width: 100%;
        text-align: center;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        margin: 0;
        flex-shrink: 1;
    }
    </style>
    <div style="color:blue;font-weight:bold;">Sticker preview is always visible on screen. If you see this, the preview is working.</div>
    <script>
    function printSticker() {
        window.print();
    }
    </script>
        <?php endif; ?>
    </div>
</body>
</html>
