<?php
include 'config.php';
date_default_timezone_set('Asia/Colombo');

echo "<h3>Sales Data Analysis</h3>";
echo "<p>Current time: " . date('Y-m-d H:i:s') . "</p>";

// Check today's sales
$today = date('Y-m-d');
echo "<h4>Today's Sales ($today):</h4>";

$query = "SELECT id, total_amount, payment_method, sale_date, customer_phone FROM sales WHERE DATE(sale_date) = '$today' ORDER BY sale_date DESC";
$result = mysqli_query($conn, $query);

echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>ID</th><th>Amount</th><th>Payment</th><th>Time</th><th>Phone</th></tr>";

$total = 0;
$count = 0;
while($row = mysqli_fetch_assoc($result)) {
    echo "<tr>";
    echo "<td>#{$row['id']}</td>";
    echo "<td>Rs " . number_format($row['total_amount'], 2) . "</td>";
    echo "<td>{$row['payment_method']}</td>";
    echo "<td>{$row['sale_date']}</td>";
    echo "<td>" . ($row['customer_phone'] ?: '-') . "</td>";
    echo "</tr>";
    
    $total += $row['total_amount'];
    $count++;
}

echo "</table>";
echo "<p><strong>Total: $count sales = Rs " . number_format($total, 2) . "</strong></p>";

if ($total != 200) {
    echo "<h4 style='color: red;'>❌ MISMATCH DETECTED!</h4>";
    echo "<p>Expected: Rs 200.00</p>";
    echo "<p>Found: Rs " . number_format($total, 2) . "</p>";
    echo "<p>Difference: Rs " . number_format($total - 200, 2) . "</p>";
    
    echo "<h4>Solutions:</h4>";
    echo "<ol>";
    echo "<li><a href='admin/cleanup_sales.php'>Use Admin Cleanup Tool</a> (Admin only)</li>";
    echo "<li>Or manually delete incorrect sales from database</li>";
    echo "</ol>";
} else {
    echo "<h4 style='color: green;'>✅ Data is correct!</h4>";
}
?>
