<?php
session_start();
require_once 'config.php';

// Create test commission record
$sales_officer_id = 1; // test officer
$sale_id = 412; // Use the most recent sale
$commission_amount = 3.00 * 0.01; // 1% of Rs. 3.00

$stmt = $conn->prepare("INSERT INTO sales_commissions (sale_id, sales_officer_id, commission_amount) VALUES (?, ?, ?)");
$stmt->bind_param("iid", $sale_id, $sales_officer_id, $commission_amount);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Test commission created',
        'sale_id' => $sale_id,
        'officer_id' => $sales_officer_id,
        'commission_amount' => $commission_amount,
        'commission_inserted_id' => $conn->insert_id
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => $stmt->error
    ]);
}
?>
