-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Oct 30, 2025 at 01:34 AM
-- Server version: 11.4.8-MariaDB-cll-lve
-- PHP Version: 8.3.26

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `cwktwqbhbk_malshan`
--

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `image` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `description`, `parent_id`, `created_at`, `image`) VALUES
(31, 'Bakary', NULL, NULL, '2025-10-13 09:46:28', NULL),
(32, 'beverage', NULL, NULL, '2025-10-25 11:33:09', NULL),
(33, 'Koththu', NULL, NULL, '2025-10-26 10:06:03', NULL),
(34, 'rice', NULL, NULL, '2025-10-28 17:25:25', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `name`, `phone`, `email`, `address`, `created_at`) VALUES
(13, 'Customer 2720', '0741582720', NULL, NULL, '2025-10-26 05:23:18'),
(14, '', '0741582720', NULL, NULL, '2025-10-26 10:27:11'),
(15, 'Customer 04.4', '0124242104.4', NULL, NULL, '2025-10-26 10:33:58');

-- --------------------------------------------------------

--
-- Table structure for table `exchange_log`
--

CREATE TABLE `exchange_log` (
  `id` int(11) NOT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `old_item_id` int(11) DEFAULT NULL,
  `new_product_id` int(11) DEFAULT NULL,
  `new_quantity` int(11) DEFAULT NULL,
  `price_diff` decimal(10,2) DEFAULT NULL,
  `exchanged_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `expenses`
--

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL,
  `expense_date` date NOT NULL,
  `category` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_method` enum('cash','card','bank_transfer') DEFAULT 'cash',
  `notes` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `held_orders`
--

CREATE TABLE `held_orders` (
  `id` int(11) NOT NULL,
  `order_number` varchar(20) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `customer_phone` varchar(20) DEFAULT NULL,
  `customer_name` varchar(100) DEFAULT NULL,
  `table_number` varchar(20) DEFAULT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `discount` decimal(5,2) DEFAULT 0.00,
  `discount_amount` decimal(10,2) DEFAULT 0.00,
  `total_amount` decimal(10,2) NOT NULL,
  `order_data` text NOT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` enum('held','resumed','cancelled','completed') DEFAULT 'held',
  `notes` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `held_orders`
--

INSERT INTO `held_orders` (`id`, `order_number`, `customer_id`, `customer_phone`, `customer_name`, `table_number`, `subtotal`, `discount`, `discount_amount`, `total_amount`, `order_data`, `created_by`, `created_at`, `updated_at`, `status`, `notes`) VALUES
(6, 'HOLD-20251013-6014', NULL, NULL, NULL, NULL, 70.00, 0.00, 0.00, 70.00, '{\"items\":[{\"product_id\":306,\"quantity\":1,\"price\":20,\"total\":20},{\"product_id\":306,\"quantity\":2,\"price\":25,\"total\":50}],\"customer_name\":null,\"table_number\":\"4\",\"notes\":null,\"discount\":0}', 'POS_USER', '2025-10-13 10:40:49', '2025-10-26 05:16:46', 'completed', NULL),
(7, 'HOLD-20251026-1934', NULL, NULL, NULL, NULL, 420.00, 0.00, 0.00, 420.00, '{\"items\":[{\"product_id\":307,\"quantity\":1,\"price\":100,\"total\":100},{\"product_id\":315,\"quantity\":1,\"price\":70,\"total\":70},{\"product_id\":313,\"quantity\":1,\"price\":250,\"total\":250}],\"customer_name\":null,\"table_number\":null,\"notes\":null,\"discount\":0}', 'POS_USER', '2025-10-26 05:13:02', '2025-10-26 05:15:09', 'completed', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `inventory_transactions`
--

CREATE TABLE `inventory_transactions` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `transaction_type` enum('sale','purchase','adjustment','return') NOT NULL,
  `quantity_change` int(11) NOT NULL,
  `old_stock` int(11) NOT NULL,
  `new_stock` int(11) NOT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `opening_cash`
--

CREATE TABLE `opening_cash` (
  `id` int(11) NOT NULL,
  `cash_date` date NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `entered_by` varchar(50) DEFAULT NULL,
  `entered_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `opening_cash`
--

INSERT INTO `opening_cash` (`id`, `cash_date`, `amount`, `entered_by`, `entered_at`) VALUES
(1, '2025-10-03', 7500.00, 'admin', '2025-10-03 09:05:33'),
(2, '2025-10-04', 7500.00, 'admin', '2025-10-04 08:36:01'),
(3, '2025-10-06', 7500.00, 'admin', '2025-10-06 12:24:48'),
(4, '2025-10-08', 7500.00, 'admin', '2025-10-08 08:40:05'),
(5, '2025-10-09', 7500.00, 'admin', '2025-10-09 09:16:13'),
(6, '2025-10-10', 2000.00, 'admin', '2025-10-10 16:45:35'),
(7, '2025-10-26', 1000.00, 'admin', '2025-10-26 15:44:41');

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `category` varchar(50) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL,
  `half_price` decimal(10,2) DEFAULT 0.00,
  `wholesale_price` decimal(10,2) DEFAULT 0.00,
  `cost_price` decimal(10,2) DEFAULT 0.00,
  `profit_margin` decimal(5,2) DEFAULT 0.00,
  `stock` int(11) DEFAULT 0,
  `min_stock` int(11) DEFAULT 5,
  `max_stock` int(11) DEFAULT 100,
  `barcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `name`, `category`, `category_id`, `supplier_id`, `price`, `half_price`, `wholesale_price`, `cost_price`, `profit_margin`, `stock`, `min_stock`, `max_stock`, `barcode`, `created_at`) VALUES
(307, 'Coca Cola (175ml)', 'beverage', NULL, NULL, 100.00, 0.00, 76.66, 0.00, 0.00, 72, 5, 100, NULL, '2025-10-25 12:50:38'),
(309, 'Sprite (175ml)', 'beverage', NULL, NULL, 100.00, 0.00, 76.66, 0.00, 0.00, 72, 5, 100, NULL, '2025-10-25 12:58:56'),
(310, 'Coca Cola (1050ml)', 'beverage', NULL, NULL, 300.00, 0.00, 275.00, 0.00, 0.00, 10, 5, 100, NULL, '2025-10-25 13:02:53'),
(311, 'Sprite (1050ml)', 'beverage', NULL, NULL, 300.00, 0.00, 275.00, 0.00, 0.00, 5, 5, 100, NULL, '2025-10-25 13:04:41'),
(313, 'L. Ginger Beer (1050ml)', 'beverage', NULL, NULL, 250.00, 0.00, 225.00, 0.00, 0.00, 10, 5, 100, NULL, '2025-10-25 13:13:17'),
(314, 'Portello (1050ml)', 'beverage', NULL, NULL, 250.00, 0.00, 225.00, 0.00, 0.00, 0, 5, 100, NULL, '2025-10-25 13:17:11'),
(315, 'Kinley Watter Bottle (500ml)', 'beverage', NULL, NULL, 70.00, 0.00, 48.00, 0.00, 0.00, 22, 5, 100, NULL, '2025-10-25 13:21:34'),
(316, 'Kinley Watter Bottle ( 1L)', 'beverage', NULL, NULL, 100.00, 0.00, 68.00, 0.00, 0.00, 22, 5, 100, NULL, '2025-10-25 13:23:40'),
(317, 'chiken rice', '', NULL, NULL, 1300.00, 650.00, 1300.00, 0.00, 0.00, 0, 5, 100, NULL, '2025-10-28 17:27:08'),
(318, 'chiken rice', '', NULL, NULL, 1300.00, 650.00, 1300.00, 0.00, 0.00, 0, 5, 100, NULL, '2025-10-28 17:27:09');

-- --------------------------------------------------------

--
-- Table structure for table `product_monitor`
--

CREATE TABLE `product_monitor` (
  `id` int(11) NOT NULL,
  `product_id` int(11) DEFAULT NULL,
  `product_name` varchar(100) DEFAULT NULL,
  `product_barcode` varchar(50) DEFAULT NULL,
  `check_time` timestamp NULL DEFAULT current_timestamp(),
  `status` enum('exists','missing') DEFAULT 'exists',
  `notes` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `promotions`
--

CREATE TABLE `promotions` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('percentage','fixed') NOT NULL,
  `value` decimal(10,2) NOT NULL,
  `min_amount` decimal(10,2) DEFAULT 0.00,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_orders`
--

CREATE TABLE `purchase_orders` (
  `id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `order_date` date NOT NULL,
  `expected_date` date DEFAULT NULL,
  `status` enum('pending','received','cancelled') DEFAULT 'pending',
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `purchase_orders`
--

INSERT INTO `purchase_orders` (`id`, `supplier_id`, `order_date`, `expected_date`, `status`, `total_amount`, `notes`, `created_by`, `created_at`) VALUES
(1, 1, '2025-10-13', '0000-00-00', 'pending', 0.00, 'hjik', 1, '2025-10-13 10:19:53');

-- --------------------------------------------------------

--
-- Table structure for table `purchase_order_items`
--

CREATE TABLE `purchase_order_items` (
  `id` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_cost` decimal(10,2) NOT NULL,
  `total_cost` decimal(10,2) NOT NULL,
  `received_quantity` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales`
--

CREATE TABLE `sales` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `held_order_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `payment_method` varchar(20) NOT NULL,
  `discount` decimal(10,2) DEFAULT 0.00,
  `tax` decimal(10,2) DEFAULT 0.00,
  `sale_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `paid_amount` decimal(10,2) DEFAULT 0.00,
  `customer_phone` varchar(20) DEFAULT NULL,
  `voucher_amount` decimal(10,2) DEFAULT 0.00,
  `secondary_payment_method` varchar(20) DEFAULT NULL,
  `secondary_amount` decimal(10,2) DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `sales`
--

INSERT INTO `sales` (`id`, `customer_id`, `held_order_id`, `created_by`, `total_amount`, `payment_method`, `discount`, `tax`, `sale_date`, `paid_amount`, `customer_phone`, `voucher_amount`, `secondary_payment_method`, `secondary_amount`) VALUES
(339, NULL, NULL, NULL, 60.00, 'cash', 0.00, 0.00, '2025-10-13 11:36:12', 0.00, NULL, 0.00, NULL, 0.00),
(340, NULL, 7, NULL, 420.00, 'cash', 0.00, 0.00, '2025-10-26 05:15:09', 500.00, NULL, 0.00, NULL, 0.00),
(341, NULL, 6, NULL, 700.00, 'cash', 0.00, 0.00, '2025-10-26 05:16:46', 1000.00, NULL, 0.00, NULL, 0.00),
(342, NULL, 6, NULL, 700.00, 'cash', 0.00, 0.00, '2025-10-26 05:16:46', 1000.00, NULL, 0.00, NULL, 0.00),
(343, NULL, NULL, NULL, 243.00, 'cash', 10.00, 0.00, '2025-10-26 05:19:36', 300.00, NULL, 0.00, NULL, 0.00),
(344, 13, NULL, NULL, 250.00, 'cash', 0.00, 0.00, '2025-10-26 10:27:11', 0.00, '0741582720', 0.00, NULL, 0.00),
(345, NULL, NULL, NULL, 300.00, 'cash', 0.00, 0.00, '2025-10-26 10:28:10', 0.00, NULL, 0.00, NULL, 0.00),
(346, NULL, NULL, NULL, 300.00, 'cash', 0.00, 0.00, '2025-10-28 17:27:46', 0.00, NULL, 0.00, NULL, 0.00),
(347, NULL, NULL, NULL, 300.00, 'cash', 0.00, 0.00, '2025-10-28 17:28:10', 0.00, NULL, 0.00, NULL, 0.00),
(348, NULL, NULL, NULL, 300.00, 'cash', 0.00, 0.00, '2025-10-28 17:28:49', 0.00, NULL, 0.00, NULL, 0.00),
(349, NULL, NULL, NULL, 300.00, 'card', 0.00, 0.00, '2025-10-28 17:31:06', 0.00, NULL, 0.00, NULL, 0.00);

-- --------------------------------------------------------

--
-- Table structure for table `sale_items`
--

CREATE TABLE `sale_items` (
  `id` int(11) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` decimal(10,2) NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `refunded` tinyint(1) DEFAULT 0,
  `exchanged` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `sale_items`
--

INSERT INTO `sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `refunded`, `exchanged`) VALUES
(470, 340, 313, 1, 250.00, 250.00, 0, 0),
(471, 340, 307, 1, 100.00, 100.00, 0, 0),
(472, 340, 315, 1, 70.00, 70.00, 0, 0),
(473, 341, 310, 1, 300.00, 300.00, 0, 0),
(474, 341, 311, 1, 300.00, 300.00, 0, 0),
(475, 341, 309, 1, 100.00, 100.00, 0, 0),
(476, 342, 310, 1, 300.00, 300.00, 0, 0),
(477, 342, 311, 1, 300.00, 300.00, 0, 0),
(478, 342, 309, 1, 100.00, 100.00, 0, 0),
(479, 343, 315, 1, 70.00, 70.00, 0, 0),
(480, 343, 316, 2, 100.00, 200.00, 0, 0),
(481, 344, 314, 1, 250.00, 250.00, 0, 0),
(482, 345, 311, 1, 300.00, 300.00, 0, 0),
(483, 346, 310, 1, 300.00, 300.00, 0, 0),
(484, 347, 310, 1, 300.00, 300.00, 0, 0),
(485, 348, 310, 1, 300.00, 300.00, 0, 0),
(486, 349, 311, 1, 300.00, 300.00, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(11) NOT NULL,
  `setting_key` varchar(50) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `suppliers`
--

CREATE TABLE `suppliers` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact_person` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `suppliers`
--

INSERT INTO `suppliers` (`id`, `name`, `contact_person`, `phone`, `email`, `address`, `created_at`) VALUES
(1, 'hgygy', 'hjvh', '0751534972', '', '122 D, Batkatiyawaththa,Haburugala', '2025-10-13 10:19:29');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `role` enum('admin','cashier','manager') DEFAULT 'cashier',
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `last_login` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `full_name`, `role`, `email`, `phone`, `is_active`, `last_login`, `created_at`) VALUES
(1, 'admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'System Administrator', 'admin', 'admin@textilepos.com', NULL, 1, '2025-10-28 17:16:40', '2025-09-07 07:23:21'),
(7, 'Ravindu', '$2y$10$NR/10a4qoSE0zLFbgBMFCu6XHn1ZVosk2lnbktsd1JtXM44qMonw2', 'Ravindu', 'cashier', '', '', 1, '2025-10-13 10:45:13', '2025-10-13 10:44:43');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `parent_id` (`parent_id`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `exchange_log`
--
ALTER TABLE `exchange_log`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `expenses`
--
ALTER TABLE `expenses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `held_orders`
--
ALTER TABLE `held_orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_number` (`order_number`),
  ADD KEY `idx_order_number` (`order_number`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `customer_id` (`customer_id`);

--
-- Indexes for table `inventory_transactions`
--
ALTER TABLE `inventory_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `opening_cash`
--
ALTER TABLE `opening_cash`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `barcode` (`barcode`);

--
-- Indexes for table `product_monitor`
--
ALTER TABLE `product_monitor`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `promotions`
--
ALTER TABLE `promotions`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `supplier_id` (`supplier_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `po_id` (`po_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `sales`
--
ALTER TABLE `sales`
  ADD PRIMARY KEY (`id`),
  ADD KEY `customer_id` (`customer_id`),
  ADD KEY `idx_sales_held_order` (`held_order_id`);

--
-- Indexes for table `sale_items`
--
ALTER TABLE `sale_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sale_id` (`sale_id`),
  ADD KEY `sale_items_ibfk_2` (`product_id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`);

--
-- Indexes for table `suppliers`
--
ALTER TABLE `suppliers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=35;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `exchange_log`
--
ALTER TABLE `exchange_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT for table `expenses`
--
ALTER TABLE `expenses`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `held_orders`
--
ALTER TABLE `held_orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `inventory_transactions`
--
ALTER TABLE `inventory_transactions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `opening_cash`
--
ALTER TABLE `opening_cash`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=319;

--
-- AUTO_INCREMENT for table `product_monitor`
--
ALTER TABLE `product_monitor`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=138;

--
-- AUTO_INCREMENT for table `promotions`
--
ALTER TABLE `promotions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales`
--
ALTER TABLE `sales`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=350;

--
-- AUTO_INCREMENT for table `sale_items`
--
ALTER TABLE `sale_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=487;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `suppliers`
--
ALTER TABLE `suppliers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `categories`
--
ALTER TABLE `categories`
  ADD CONSTRAINT `categories_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `categories` (`id`);

--
-- Constraints for table `expenses`
--
ALTER TABLE `expenses`
  ADD CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `held_orders`
--
ALTER TABLE `held_orders`
  ADD CONSTRAINT `held_orders_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`);

--
-- Constraints for table `inventory_transactions`
--
ALTER TABLE `inventory_transactions`
  ADD CONSTRAINT `inventory_transactions_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  ADD CONSTRAINT `inventory_transactions_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD CONSTRAINT `purchase_orders_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`),
  ADD CONSTRAINT `purchase_orders_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  ADD CONSTRAINT `purchase_order_items_ibfk_1` FOREIGN KEY (`po_id`) REFERENCES `purchase_orders` (`id`),
  ADD CONSTRAINT `purchase_order_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`);

--
-- Constraints for table `sales`
--
ALTER TABLE `sales`
  ADD CONSTRAINT `fk_sales_held_order` FOREIGN KEY (`held_order_id`) REFERENCES `held_orders` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `sales_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`);

--
-- Constraints for table `sale_items`
--
ALTER TABLE `sale_items`
  ADD CONSTRAINT `sale_items_ibfk_1` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`),
  ADD CONSTRAINT `sale_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
