<?php
/**
 * 404 Error Debugging Tool
 * This file helps identify and track 404 errors in the application
 */

date_default_timezone_set('Asia/Colombo');
session_start();

// Log 404 errors to a file
function log404Error($request_uri, $referer, $user_agent) {
    $log_file = __DIR__ . '/404_errors.log';
    $timestamp = date('Y-m-d H:i:s');
    $user_id = $_SESSION['user_id'] ?? 'Not logged in';
    
    $log_entry = sprintf(
        "[%s] 404 Error\nRequested URL: %s\nReferer: %s\nUser Agent: %s\nUser ID: %s\n%s\n",
        $timestamp,
        $request_uri,
        $referer,
        $user_agent,
        $user_id,
        str_repeat('-', 80)
    );
    
    file_put_contents($log_file, $log_entry, FILE_APPEND);
}

// Check if this is a 404 error
$is_404 = false;
$request_uri = $_SERVER['REQUEST_URI'] ?? '';
$referer = $_SERVER['HTTP_REFERER'] ?? 'Direct access';
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

// Log this error
log404Error($request_uri, $referer, $user_agent);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Page Not Found - Dilrukshi Tex</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .error-container {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 600px;
        }
    </style>
</head>
<body>
    <div class="error-container text-center">
        <h1 class="display-1 text-danger">404</h1>
        <h2 class="mb-4">Page Not Found</h2>
        <p class="text-muted mb-4">
            The page you are looking for might have been removed, had its name changed, 
            or is temporarily unavailable.
        </p>
        
        <div class="alert alert-info text-start">
            <strong>Technical Details:</strong><br>
            <small>
                <strong>Requested URL:</strong> <?= htmlspecialchars($request_uri) ?><br>
                <strong>Referred from:</strong> <?= htmlspecialchars($referer) ?><br>
                <strong>Timestamp:</strong> <?= date('Y-m-d H:i:s') ?>
            </small>
        </div>
        
        <div class="d-grid gap-2 mt-4">
            <a href="/malshanlast/dashboard.php" class="btn btn-primary btn-lg">
                <i class="fas fa-home"></i> Go to Dashboard
            </a>
            <button onclick="window.history.back()" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Go Back
            </button>
        </div>
        
        <p class="text-muted mt-4 small">
            This error has been logged for review by the system administrator.
        </p>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
</body>
</html>
