<?php
date_default_timezone_set('Asia/Colombo');
include '../config.php';

// Debug database connection
echo "Database connection: ";
if ($conn) {
    echo "✓ Connected<br>";
} else {
    echo "✗ Failed<br>";
    die("Connection failed: " . mysqli_connect_error());
}

// Check if wholesale_price column exists
$result = $conn->query("DESCRIBE products");
$columns = [];
while ($row = $result->fetch_assoc()) {
    $columns[] = $row['Field'];
}

echo "Database columns: " . implode(', ', $columns) . "<br><br>";

// Handle add product
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "Form submitted!<br>";
    print_r($_POST);
    
    $name = $_POST['name'];
    $category = $_POST['category'];
    $wholesale_price = $_POST['wholesale_price'] ?? 0;
    $price = $_POST['price'];
    $stock = $_POST['stock'];
    $barcode = !empty($_POST['barcode']) ? $_POST['barcode'] : null;
    
    echo "<br>Values to insert:<br>";
    echo "Name: $name<br>";
    echo "Category: $category<br>";
    echo "Wholesale: $wholesale_price<br>";
    echo "Price: $price<br>";
    echo "Stock: $stock<br>";
    echo "Barcode: $barcode<br><br>";
    
    $stmt = $conn->prepare('INSERT INTO products (name, category, wholesale_price, price, stock, barcode) VALUES (?, ?, ?, ?, ?, ?)');
    if ($stmt) {
        $stmt->bind_param('ssddis', $name, $category, $wholesale_price, $price, $stock, $barcode);
        if ($stmt->execute()) {
            echo "✓ Product added successfully!<br>";
        } else {
            echo "✗ Error executing: " . $stmt->error . "<br>";
        }
        $stmt->close();
    } else {
        echo "✗ Error preparing statement: " . $conn->error . "<br>";
    }
}

// Fetch products
$result = $conn->query('SELECT * FROM products');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Debug Products</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-4">
        <h2>Debug Products Page</h2>
        
        <div class="card mb-4">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <span><i class="fas fa-plus"></i> Add New Product</span>
                <div>
                    <button type="button" class="btn btn-light btn-sm me-2">Add Category</button>
                    <button type="button" class="btn btn-light btn-sm me-2">Choose File</button>
                    <button type="submit" form="productForm" class="btn btn-success btn-sm">Add</button>
                </div>
            </div>
            <div class="card-body">
                <form method="post" id="productForm">
                    <div class="row g-3">
                        <div class="col-md-2">
                            <label class="form-label">Product Name *</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Category</label>
                            <select name="category" class="form-select">
                                <option value="">Select...</option>
                                <option value="Electronics">Electronics</option>
                                <option value="Clothing">Clothing</option>
                                <option value="Food">Food</option>
                                <option value="Books">Books</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Wholesale Price *</label>
                            <input type="number" step="0.01" name="wholesale_price" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Selling Price *</label>
                            <input type="number" step="0.01" name="price" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Stock *</label>
                            <input type="number" name="stock" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Barcode</label>
                            <input type="text" name="barcode" class="form-control" placeholder="Optional">
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">Products List</div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Wholesale Price</th>
                            <th>Selling Price</th>
                            <th>Stock</th>
                            <th>Barcode</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result && $result->num_rows > 0): ?>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $row['id'] ?></td>
                                    <td><?= htmlspecialchars($row['name']) ?></td>
                                    <td><?= htmlspecialchars($row['category']) ?></td>
                                    <td>Rs <?= number_format($row['wholesale_price'] ?? 0, 2) ?></td>
                                    <td>Rs <?= number_format($row['price'], 2) ?></td>
                                    <td><?= $row['stock'] ?></td>
                                    <td><?= htmlspecialchars($row['barcode'] ?? 'N/A') ?></td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">No products found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>