<?php
include 'config.php';
date_default_timezone_set('Asia/Colombo');

echo "=== SALES INVESTIGATION ===\n";
echo "Current server time: " . date('Y-m-d H:i:s') . "\n";
echo "Today's date: " . date('Y-m-d') . "\n\n";

// Check all sales for today
echo "=== TODAY'S SALES ===\n";
$today_sales_query = "SELECT id, total_amount, payment_method, sale_date, customer_phone 
                      FROM sales 
                      WHERE DATE(sale_date) = CURDATE() 
                      ORDER BY sale_date DESC";
$result = mysqli_query($conn, $today_sales_query);

$total_found = 0;
$count = 0;
while($row = mysqli_fetch_assoc($result)) {
    $count++;
    $total_found += $row['total_amount'];
    echo "Sale #{$row['id']}: Rs {$row['total_amount']} ({$row['payment_method']}) at {$row['sale_date']} - Phone: {$row['customer_phone']}\n";
}

echo "\nTotal sales found: $count\n";
echo "Total amount: Rs " . number_format($total_found, 2) . "\n\n";

// Check if there are sales from other dates
echo "=== ALL RECENT SALES (Last 3 days) ===\n";
$recent_query = "SELECT DATE(sale_date) as sale_day, COUNT(*) as count, SUM(total_amount) as daily_total 
                 FROM sales 
                 WHERE sale_date >= DATE_SUB(CURDATE(), INTERVAL 3 DAY)
                 GROUP BY DATE(sale_date) 
                 ORDER BY sale_day DESC";
$recent_result = mysqli_query($conn, $recent_query);

while($row = mysqli_fetch_assoc($recent_result)) {
    echo "Date: {$row['sale_day']} - {$row['count']} sales - Rs " . number_format($row['daily_total'], 2) . "\n";
}

// Check the enhanced_stats calculation
echo "\n=== DASHBOARD CALCULATION ===\n";
$dashboard_query = "SELECT COALESCE(SUM(total_amount), 0) as total FROM sales WHERE DATE(sale_date) = CURDATE()";
$dashboard_result = mysqli_query($conn, $dashboard_query);
$dashboard_total = mysqli_fetch_assoc($dashboard_result)['total'];
echo "Dashboard shows: Rs " . number_format($dashboard_total, 2) . "\n";
?>
