<?php
include 'config.php';
date_default_timezone_set('Asia/Colombo');

echo "<h2>Product Deletion Tracker</h2>";
echo "<p>Current time: " . date('Y-m-d H:i:s') . "</p>";

// Check if someone is trying to delete products right now
if (isset($_GET['delete'])) {
    $delete_id = $_GET['delete'];
    $user_info = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 'ANONYMOUS';
    $user_ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    $referer = $_SERVER['HTTP_REFERER'] ?? 'direct';
    
    $log_entry = date('Y-m-d H:i:s') . " - DELETION ATTEMPT DETECTED!\n";
    $log_entry .= "  Product ID: $delete_id\n";
    $log_entry .= "  User: $user_info\n";
    $log_entry .= "  IP: $user_ip\n";
    $log_entry .= "  User Agent: $user_agent\n";
    $log_entry .= "  Referer: $referer\n";
    $log_entry .= "  GET params: " . print_r($_GET, true) . "\n";
    $log_entry .= "  POST params: " . print_r($_POST, true) . "\n\n";
    
    file_put_contents('deletion_attempts.log', $log_entry, FILE_APPEND);
    
    echo "<div style='color: red; border: 2px solid red; padding: 10px;'>";
    echo "<h3>🚨 DELETION ATTEMPT INTERCEPTED!</h3>";
    echo "<p>Someone tried to delete product ID: <strong>$delete_id</strong></p>";
    echo "<p>This has been logged for investigation.</p>";
    echo "</div>";
}

// Monitor products that were created today
echo "<h3>Products Created Today</h3>";
$today_products = $conn->query("
    SELECT id, name, barcode, created_at, stock 
    FROM products 
    WHERE DATE(created_at) = CURDATE() 
    ORDER BY created_at DESC
");

if ($today_products->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>Name</th><th>Barcode</th><th>Created</th><th>Stock</th><th>Monitor</th></tr>";
    
    while ($row = $today_products->fetch_assoc()) {
        echo "<tr>";
        echo "<td>{$row['id']}</td>";
        echo "<td>{$row['name']}</td>";
        echo "<td>{$row['barcode']}</td>";
        echo "<td>{$row['created_at']}</td>";
        echo "<td>{$row['stock']}</td>";
        echo "<td><a href='?monitor={$row['id']}'>Track This Product</a></td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No products created today.</p>";
}

// Show deletion attempts log
echo "<h3>Recent Deletion Attempts</h3>";
if (file_exists('deletion_attempts.log')) {
    $log_content = file_get_contents('deletion_attempts.log');
    echo "<pre style='background: #f0f0f0; padding: 10px; max-height: 300px; overflow-y: scroll;'>";
    echo htmlspecialchars($log_content);
    echo "</pre>";
} else {
    echo "<p>No deletion attempts logged yet.</p>";
}

// Monitor specific product if requested
if (isset($_GET['monitor'])) {
    $product_id = intval($_GET['monitor']);
    echo "<h3>Monitoring Product ID: $product_id</h3>";
    
    // Check if product exists
    $check = $conn->prepare("SELECT id, name, barcode FROM products WHERE id = ?");
    $check->bind_param('i', $product_id);
    $check->execute();
    $result = $check->get_result();
    
    if ($result->num_rows > 0) {
        $product = $result->fetch_assoc();
        echo "<p style='color: green;'>✅ Product exists: {$product['name']} (Barcode: {$product['barcode']})</p>";
        
        // Log this monitoring check
        $monitor_log = date('Y-m-d H:i:s') . " - Product ID $product_id still exists\n";
        file_put_contents('product_monitoring.log', $monitor_log, FILE_APPEND);
    } else {
        echo "<p style='color: red;'>❌ Product ID $product_id has DISAPPEARED!</p>";
        
        // Log the disappearance
        $disappear_log = date('Y-m-d H:i:s') . " - PRODUCT DISAPPEARED! ID $product_id no longer exists\n";
        file_put_contents('product_disappearances.log', $disappear_log, FILE_APPEND);
    }
}

echo "<hr>";
echo "<h3>Instructions</h3>";
echo "<ol>";
echo "<li><strong>Bookmark this page</strong> and check it frequently</li>";
echo "<li>After adding a new product, click 'Track This Product' next to it</li>";
echo "<li>This page will log any deletion attempts and show exactly who is trying to delete products</li>";
echo "<li>Check back tomorrow to see if tracked products have disappeared</li>";
echo "</ol>";

// Add JavaScript to auto-refresh every 30 seconds
echo "<script>
    setTimeout(function() {
        location.reload();
    }, 30000);
    
    console.log('Product Deletion Tracker running...');
</script>";
?>