<?php
session_start();
require_once 'config.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

$commission_log = [];
$sale_data_log = [];

// Read commission log
if (file_exists('pos/commission_log.txt')) {
    $lines = file('pos/commission_log.txt');
    $commission_log = array_slice($lines, -10); // Last 10 lines
    $commission_log = array_map('trim', $commission_log);
}

// Read sale data log (last few entries)
if (file_exists('pos/sale_data_log.txt')) {
    $content = file_get_contents('pos/sale_data_log.txt');
    // Extract last 2 entries (roughly)
    $entries = explode("\n2025-", $content);
    if (count($entries) > 1) {
        $last_entries = array_slice($entries, -3);
        foreach ($last_entries as $entry) {
            if (!empty(trim($entry))) {
                $sale_data_log[] = "2025-" . substr($entry, 0, 500);
            }
        }
    }
}

echo json_encode([
    'commission_log' => $commission_log,
    'sale_data_log' => $sale_data_log
]);
?>
