<!DOCTYPE html>
<html>
<head>
    <title>Icon Test - Textile POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://use.fontawesome.com/releases/v6.4.0/css/all.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; }
        .test-card { background: rgba(255,255,255,0.1); padding: 20px; margin: 10px; border-radius: 10px; }
        .icon-test { font-size: 3rem; margin: 10px; }
        .status { font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Icon Loading Diagnostic</h1>
        
        <div class="test-card">
            <h3>Font Awesome Test</h3>
            <div class="row">
                <div class="col-md-2 text-center">
                    <i class="fas fa-shield-alt icon-test text-warning"></i>
                    <p>Shield</p>
                </div>
                <div class="col-md-2 text-center">
                    <i class="fas fa-cash-register icon-test text-success"></i>
                    <p>Cash Register</p>
                </div>
                <div class="col-md-2 text-center">
                    <i class="fas fa-barcode icon-test text-info"></i>
                    <p>Barcode</p>
                </div>
                <div class="col-md-2 text-center">
                    <i class="fas fa-box icon-test text-primary"></i>
                    <p>Box</p>
                </div>
                <div class="col-md-2 text-center">
                    <i class="fas fa-chart-line icon-test text-danger"></i>
                    <p>Chart</p>
                </div>
                <div class="col-md-2 text-center">
                    <i class="fas fa-users icon-test text-secondary"></i>
                    <p>Users</p>
                </div>
            </div>
        </div>
        
        <div class="test-card">
            <h3>Emoji Fallbacks (Always Work)</h3>
            <div class="row">
                <div class="col-md-2 text-center">
                    <div class="icon-test">🛡️</div>
                    <p>Shield</p>
                </div>
                <div class="col-md-2 text-center">
                    <div class="icon-test">💰</div>
                    <p>Money</p>
                </div>
                <div class="col-md-2 text-center">
                    <div class="icon-test">📊</div>
                    <p>Chart</p>
                </div>
                <div class="col-md-2 text-center">
                    <div class="icon-test">📦</div>
                    <p>Package</p>
                </div>
                <div class="col-md-2 text-center">
                    <div class="icon-test">📈</div>
                    <p>Trending</p>
                </div>
                <div class="col-md-2 text-center">
                    <div class="icon-test">👥</div>
                    <p>People</p>
                </div>
            </div>
        </div>
        
        <div class="test-card">
            <h3>Font Awesome Status</h3>
            <p class="status" id="fontStatus">Checking...</p>
            <p><strong>CSS URLs:</strong></p>
            <ul id="cssUrls"></ul>
            <p><strong>Network Status:</strong> <span id="networkStatus">Checking...</span></p>
        </div>
        
        <div class="text-center mt-4">
            <a href="dashboard.php" class="btn btn-primary">Back to Dashboard</a>
            <button onclick="location.reload()" class="btn btn-secondary">Reload Test</button>
        </div>
    </div>

    <script>
        function checkFontAwesome() {
            const testIcon = document.querySelector('.fas.fa-shield-alt');
            const statusElement = document.getElementById('fontStatus');
            
            setTimeout(function() {
                if (testIcon) {
                    const computedStyle = window.getComputedStyle(testIcon, '::before');
                    const content = computedStyle.getPropertyValue('content');
                    const fontFamily = computedStyle.getPropertyValue('font-family');
                    
                    console.log('Icon content:', content);
                    console.log('Font family:', fontFamily);
                    
                    if (content && content !== 'none' && content !== '""') {
                        statusElement.innerHTML = '✅ Font Awesome is working correctly!';
                        statusElement.className = 'status text-success';
                    } else {
                        statusElement.innerHTML = '❌ Font Awesome failed to load. Icons will show as emoji fallbacks.';
                        statusElement.className = 'status text-danger';
                    }
                } else {
                    statusElement.innerHTML = '❌ No Font Awesome icons found on page.';
                    statusElement.className = 'status text-warning';
                }
            }, 1000);
        }
        
        function checkCSS() {
            const cssUrls = document.getElementById('cssUrls');
            const stylesheets = document.querySelectorAll('link[rel="stylesheet"]');
            
            stylesheets.forEach(function(link) {
                if (link.href.includes('font-awesome')) {
                    const li = document.createElement('li');
                    li.innerHTML = '<code>' + link.href + '</code>';
                    cssUrls.appendChild(li);
                }
            });
        }
        
        function checkNetwork() {
            const networkStatus = document.getElementById('networkStatus');
            
            fetch('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', {method: 'HEAD'})
                .then(response => {
                    if (response.ok) {
                        networkStatus.innerHTML = '✅ CDN reachable';
                        networkStatus.className = 'text-success';
                    } else {
                        networkStatus.innerHTML = '❌ CDN returned error: ' + response.status;
                        networkStatus.className = 'text-danger';
                    }
                })
                .catch(error => {
                    networkStatus.innerHTML = '❌ Network error: ' + error.message;
                    networkStatus.className = 'text-danger';
                });
        }
        
        checkFontAwesome();
        checkCSS();
        checkNetwork();
    </script>
</body>
</html>