<?php
include 'config.php';
include 'auth.php';
checkAuth();
$user = getCurrentUser();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Icon Test Dashboard - Textile POS</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- NO CSP RESTRICTIONS - TESTING VERSION -->
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome CSS - Multiple Sources -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://use.fontawesome.com/releases/v6.4.0/css/all.css" rel="stylesheet">
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    
    <style>
        body { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            min-height: 100vh; 
            color: white;
        }
        .test-card { 
            background: rgba(255,255,255,0.95); 
            border-radius: 15px; 
            color: black;
            margin: 20px 0;
        }
        .icon-large { font-size: 3rem; margin: 15px; }
        .status-indicator {
            padding: 5px 10px;
            border-radius: 5px;
            font-weight: bold;
            display: inline-block;
            margin: 5px;
        }
        .status-ok { background: #28a745; color: white; }
        .status-fail { background: #dc3545; color: white; }
        .status-loading { background: #ffc107; color: black; }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h1 class="text-center mb-4">🔧 ICON LOADING TEST (No CSP)</h1>
        <p class="text-center lead">Testing if icons load without Content Security Policy restrictions</p>
        
        <!-- User Info -->
        <div class="test-card p-3">
            <h4>👤 Logged in as: <?= htmlspecialchars($user['username']) ?> (<?= htmlspecialchars($user['role']) ?>)</h4>
        </div>
        
        <!-- Icon Test Grid -->
        <div class="test-card p-4">
            <h3>Font Awesome 6 Icons Test</h3>
            <div class="row text-center">
                <div class="col-md-2">
                    <i class="fas fa-shield-alt icon-large text-warning" id="icon1"></i>
                    <p>Shield</p>
                    <div class="status-indicator status-loading" id="status1">Loading...</div>
                </div>
                <div class="col-md-2">
                    <i class="fas fa-cash-register icon-large text-success" id="icon2"></i>
                    <p>Cash Register</p>
                    <div class="status-indicator status-loading" id="status2">Loading...</div>
                </div>
                <div class="col-md-2">
                    <i class="fas fa-barcode icon-large text-info" id="icon3"></i>
                    <p>Barcode</p>
                    <div class="status-indicator status-loading" id="status3">Loading...</div>
                </div>
                <div class="col-md-2">
                    <i class="fas fa-box icon-large text-primary" id="icon4"></i>
                    <p>Products</p>
                    <div class="status-indicator status-loading" id="status4">Loading...</div>
                </div>
                <div class="col-md-2">
                    <i class="fas fa-users icon-large text-secondary" id="icon5"></i>
                    <p>Users</p>
                    <div class="status-indicator status-loading" id="status5">Loading...</div>
                </div>
                <div class="col-md-2">
                    <i class="fas fa-chart-line icon-large text-danger" id="icon6"></i>
                    <p>Analytics</p>
                    <div class="status-indicator status-loading" id="status6">Loading...</div>
                </div>
            </div>
        </div>
        
        <!-- Font Awesome 4 Fallback Test -->
        <div class="test-card p-4">
            <h3>Font Awesome 4 Icons Test (Fallback)</h3>
            <div class="row text-center">
                <div class="col-md-3">
                    <i class="fa fa-home icon-large text-primary" id="icon7"></i>
                    <p>Home</p>
                    <div class="status-indicator status-loading" id="status7">Loading...</div>
                </div>
                <div class="col-md-3">
                    <i class="fa fa-user icon-large text-success" id="icon8"></i>
                    <p>User</p>
                    <div class="status-indicator status-loading" id="status8">Loading...</div>
                </div>
                <div class="col-md-3">
                    <i class="fa fa-cog icon-large text-warning" id="icon9"></i>
                    <p>Settings</p>
                    <div class="status-indicator status-loading" id="status9">Loading...</div>
                </div>
                <div class="col-md-3">
                    <i class="fa fa-heart icon-large text-danger" id="icon10"></i>
                    <p>Heart</p>
                    <div class="status-indicator status-loading" id="status10">Loading...</div>
                </div>
            </div>
        </div>
        
        <!-- Network Test -->
        <div class="test-card p-4">
            <h3>📡 Network Connectivity Test</h3>
            <div id="network-results">Testing CDN accessibility...</div>
        </div>
        
        <!-- Browser Console Errors -->
        <div class="test-card p-4">
            <h3>❌ JavaScript Console Errors</h3>
            <div id="console-errors" style="background: #f8f9fa; padding: 15px; border-radius: 5px; font-family: monospace;">
                No errors detected yet...
            </div>
        </div>
        
        <!-- Action Buttons -->
        <div class="text-center mb-4">
            <button onclick="testAllIcons()" class="btn btn-warning btn-lg me-3">
                <i class="fas fa-sync"></i> Re-test Icons
            </button>
            <a href="dashboard.php" class="btn btn-primary btn-lg me-3">
                <i class="fas fa-arrow-left"></i> Back to Main Dashboard
            </a>
            <a href="comprehensive_diagnostic.php" class="btn btn-info btn-lg">
                <i class="fas fa-search"></i> Full Diagnostic
            </a>
        </div>
    </div>

    <script>
        let consoleErrors = [];
        
        // Capture console errors
        window.onerror = function(msg, url, line, col, error) {
            consoleErrors.push(`${new Date().toISOString()}: ${msg} at ${url}:${line}:${col}`);
            updateConsoleErrors();
        };
        
        function updateConsoleErrors() {
            document.getElementById('console-errors').innerHTML = 
                consoleErrors.length > 0 ? consoleErrors.join('<br>') : 'No errors detected yet...';
        }
        
        function testIconStatus(iconId, statusId) {
            const icon = document.getElementById(iconId);
            const status = document.getElementById(statusId);
            
            if (!icon) {
                status.textContent = 'Element not found';
                status.className = 'status-indicator status-fail';
                return;
            }
            
            // Check if icon loaded by examining computed styles
            const computedStyle = window.getComputedStyle(icon, '::before');
            const content = computedStyle.getPropertyValue('content');
            const fontFamily = computedStyle.getPropertyValue('font-family');
            
            console.log(`Icon ${iconId}: content="${content}", font-family="${fontFamily}"`);
            
            if (content && content !== 'none' && content !== '""') {
                status.textContent = '✅ Loaded';
                status.className = 'status-indicator status-ok';
            } else {
                status.textContent = '❌ Failed';
                status.className = 'status-indicator status-fail';
            }
        }
        
        function testAllIcons() {
            setTimeout(function() {
                for (let i = 1; i <= 10; i++) {
                    testIconStatus(`icon${i}`, `status${i}`);
                }
            }, 1000);
        }
        
        function testNetworkConnectivity() {
            const networkDiv = document.getElementById('network-results');
            const cdnUrls = [
                'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css',
                'https://use.fontawesome.com/releases/v6.4.0/css/all.css',
                'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css'
            ];
            
            let results = '<ul>';
            let completed = 0;
            
            cdnUrls.forEach(function(url, index) {
                fetch(url, {method: 'HEAD'})
                    .then(response => {
                        completed++;
                        results += `<li>✅ ${url.split('/')[2]} - Status: ${response.status}</li>`;
                        if (completed === cdnUrls.length) {
                            networkDiv.innerHTML = results + '</ul>';
                        }
                    })
                    .catch(error => {
                        completed++;
                        results += `<li>❌ ${url.split('/')[2]} - Error: ${error.message}</li>`;
                        if (completed === cdnUrls.length) {
                            networkDiv.innerHTML = results + '</ul>';
                        }
                    });
            });
        }
        
        // Run tests on page load
        setTimeout(function() {
            testAllIcons();
            testNetworkConnectivity();
        }, 500);
        
        console.log('Icon test page loaded. User:', '<?= $user['username'] ?>');
    </script>
</body>
</html>