<?php
/**
 * Performance Monitor Widget
 * Include this in dashboard to show real-time performance metrics
 */

// Get page load time
$page_start_time = microtime(true);

// Get database query count (track this globally)
if (!isset($GLOBALS['query_count'])) {
    $GLOBALS['query_count'] = 0;
}

// Function to track queries
function trackQuery() {
    $GLOBALS['query_count']++;
}

// Function to get performance stats
function getPerformanceStats() {
    global $page_start_time;
    
    $stats = [
        'page_load_time' => round((microtime(true) - $page_start_time) * 1000, 2),
        'query_count' => $GLOBALS['query_count'] ?? 0,
        'memory_usage' => round(memory_get_usage() / 1024 / 1024, 2),
        'peak_memory' => round(memory_get_peak_usage() / 1024 / 1024, 2),
    ];
    
    return $stats;
}

// Function to display performance badge
function showPerformanceBadge() {
    $stats = getPerformanceStats();
    
    $badge_color = 'success';
    if ($stats['page_load_time'] > 500) $badge_color = 'warning';
    if ($stats['page_load_time'] > 1000) $badge_color = 'danger';
    
    echo '<div class="position-fixed bottom-0 end-0 m-3" style="z-index: 1000; opacity: 0.8;" id="performance-badge">';
    echo '<div class="card shadow-sm">';
    echo '<div class="card-body p-2" style="font-size: 0.75rem;">';
    echo '<strong>⚡ Performance:</strong><br>';
    echo '<span class="badge bg-' . $badge_color . '">' . $stats['page_load_time'] . 'ms</span> ';
    echo '<span class="badge bg-info">' . $stats['query_count'] . ' queries</span> ';
    echo '<span class="badge bg-secondary">' . $stats['memory_usage'] . ' MB</span>';
    echo '</div></div></div>';
}
?>
