<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    die("Please login first");
}

include '../config.php';
date_default_timezone_set('Asia/Colombo');

$selected_date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

echo "<h2>Debug Daily Summary for $selected_date</h2>";
echo "<p>Current time: " . date('Y-m-d H:i:s') . "</p>";

try {
    // Test basic connection
    echo "<h3>✓ Database Connected</h3>";
    
    // Test sales query
    $query = "SELECT * FROM sales WHERE DATE(sale_date) = ? ORDER BY sale_date DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $selected_date);
    $stmt->execute();
    $result = $stmt->get_result();
    
    echo "<h3>Sales for $selected_date:</h3>";
    if ($result->num_rows > 0) {
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Amount</th><th>Payment</th><th>Date</th><th>Phone</th></tr>";
        
        $total = 0;
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>{$row['id']}</td>";
            echo "<td>Rs " . number_format($row['total_amount'], 2) . "</td>";
            echo "<td>{$row['payment_method']}</td>";
            echo "<td>{$row['sale_date']}</td>";
            echo "<td>" . ($row['customer_phone'] ?: '-') . "</td>";
            echo "</tr>";
            $total += $row['total_amount'];
        }
        echo "</table>";
        echo "<p><strong>Total: Rs " . number_format($total, 2) . "</strong></p>";
    } else {
        echo "<p>No sales found for this date.</p>";
    }
    
    // Test cash sales
    $cash_query = "SELECT COUNT(*) as count, COALESCE(SUM(total_amount), 0) as total 
                   FROM sales 
                   WHERE DATE(sale_date) = ? AND payment_method = 'cash'";
    $stmt = $conn->prepare($cash_query);
    $stmt->bind_param("s", $selected_date);
    $stmt->execute();
    $cash_result = $stmt->get_result()->fetch_assoc();
    
    echo "<h3>Summary:</h3>";
    echo "<p>Cash Sales: {$cash_result['count']} transactions = Rs " . number_format($cash_result['total'], 2) . "</p>";
    
    // Test card sales
    $card_query = "SELECT COUNT(*) as count, COALESCE(SUM(total_amount), 0) as total 
                   FROM sales 
                   WHERE DATE(sale_date) = ? AND payment_method = 'card'";
    $stmt = $conn->prepare($card_query);
    $stmt->bind_param("s", $selected_date);
    $stmt->execute();
    $card_result = $stmt->get_result()->fetch_assoc();
    
    echo "<p>Card Sales: {$card_result['count']} transactions = Rs " . number_format($card_result['total'], 2) . "</p>";
    
    $total_amount = $cash_result['total'] + $card_result['total'];
    $total_transactions = $cash_result['count'] + $card_result['count'];
    
    echo "<p><strong>Total Sales: $total_transactions transactions = Rs " . number_format($total_amount, 2) . "</strong></p>";
    
    if ($total_amount > 0) {
        echo "<p style='color: green;'>✓ Data looks good! The main daily summary should work.</p>";
        echo "<p><a href='daily_summary.php?date=$selected_date'>→ Go to Full Daily Summary</a></p>";
    } else {
        echo "<p style='color: orange;'>⚠ No sales data found for this date.</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>

<style>
table { border-collapse: collapse; width: 100%; }
th, td { padding: 8px; text-align: left; }
th { background-color: #f2f2f2; }
</style>
