<?php
include 'config.php';
include 'auth.php';
checkRole('manager');

date_default_timezone_set('Asia/Colombo');

// Ensure table exists
$conn->query("CREATE TABLE IF NOT EXISTS sales_officers (id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(255) NOT NULL, is_active TINYINT(1) DEFAULT 1, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");

// Toggle status
if (isset($_GET['toggle']) && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $conn->query("UPDATE sales_officers SET is_active = IF(is_active=1,0,1) WHERE id = {$id}");
    header('Location: sales_officers.php');
    exit;
}

// Add new officer
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['name'])) {
    $name = trim($_POST['name']);
    if ($name === '') {
        $message = 'Name is required';
    } else {
        $stmt = $conn->prepare("INSERT INTO sales_officers (name) VALUES (?)");
        $stmt->bind_param('s', $name);
        if ($stmt->execute()) {
            $message = 'Sales officer added';
        } else {
            $message = 'Error adding sales officer';
        }
    }
}

$officers = $conn->query("SELECT * FROM sales_officers ORDER BY is_active DESC, name ASC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Sales Officers</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="fas fa-users"></i> Sales Officers</h3>
        <div>
            <a href="dashboard.php" class="btn btn-secondary btn-sm">Dashboard</a>
        </div>
    </div>
    <?php if ($message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <div class="card mb-4">
        <div class="card-header">Add Sales Officer</div>
        <div class="card-body">
            <form method="post" class="row g-2">
                <div class="col-md-6">
                    <input type="text" name="name" class="form-control" placeholder="Name" required>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">Add</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">Current Sales Officers</div>
        <div class="card-body p-0">
            <table class="table mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Added</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($officers && $officers->num_rows > 0): ?>
                        <?php while ($o = $officers->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($o['name']) ?></td>
                                <td><?= $o['is_active'] ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>' ?></td>
                                <td><?= date('M d, Y', strtotime($o['created_at'])) ?></td>
                                <td class="text-end">
                                    <a href="?toggle=1&id=<?= $o['id'] ?>" class="btn btn-sm btn-outline-primary">Toggle</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="4" class="text-center text-muted p-3">No sales officers yet.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
</body>
</html>
