<?php
// System Setup Verification
include 'config.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>System Verification - Textile POS</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css' rel='stylesheet'>
    <style>body { background: #f8f9fa; padding: 20px; }</style>
</head>
<body>
<div class='container'>
<h1 class='text-center mb-4'>🏪 Textile POS System Verification</h1>";

$checks = [
    'Database Connection' => false,
    'Products Table' => false,
    'Customers Table' => false,
    'Sales Table' => false,
    'Sale Items Table' => false,
    'Sample Data' => false
];

// Test database connection
try {
    if ($conn->ping()) {
        $checks['Database Connection'] = true;
        echo "<div class='alert alert-success'>✅ Database Connected Successfully</div>";
    }
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>❌ Database Connection Failed: " . $e->getMessage() . "</div>";
}

// Check tables
$tables = ['products', 'customers', 'sales', 'sale_items'];
foreach ($tables as $table) {
    $result = $conn->query("SHOW TABLES LIKE '$table'");
    if ($result->num_rows > 0) {
        $checks[ucfirst($table) . ' Table'] = true;
        echo "<div class='alert alert-success'>✅ Table '$table' exists</div>";
    } else {
        echo "<div class='alert alert-warning'>⚠️ Table '$table' missing - run database_setup.sql</div>";
    }
}

// Check for sample data
$product_count = $conn->query("SELECT COUNT(*) as count FROM products")->fetch_assoc()['count'] ?? 0;
if ($product_count > 0) {
    $checks['Sample Data'] = true;
    echo "<div class='alert alert-success'>✅ Sample products loaded ($product_count products)</div>";
} else {
    echo "<div class='alert alert-warning'>⚠️ No products found - run database_setup.sql to load sample data</div>";
}

echo "<div class='card mt-4'>
<div class='card-header bg-primary text-white'><h3>System Status</h3></div>
<div class='card-body'>";

$all_good = true;
foreach ($checks as $check => $status) {
    $icon = $status ? '✅' : '❌';
    $class = $status ? 'text-success' : 'text-danger';
    echo "<div class='$class'><strong>$icon $check</strong></div>";
    if (!$status) $all_good = false;
}

if ($all_good) {
    echo "<div class='alert alert-success mt-3'>
    <h4>🎉 System Ready!</h4>
    <p>Your Textile POS system is fully configured and ready to use.</p>
    <a href='pos/' class='btn btn-primary me-2'>Open POS Terminal</a>
    <a href='.' class='btn btn-secondary'>Go to Dashboard</a>
    </div>";
} else {
    echo "<div class='alert alert-warning mt-3'>
    <h4>⚠️ Setup Required</h4>
    <p>Please import the database_setup.sql file into your MySQL database to complete setup.</p>
    <pre class='bg-light p-2 mt-2'>mysql -u root -p textile_pos < database_setup.sql</pre>
    </div>";
}

echo "</div></div></div></body></html>";
?>
