<?php
// Simple test to verify upload and database
include 'config.php';

echo "<h2>System Check</h2>";

// Check database connection
echo "<p><strong>Database Connection:</strong> ";
if ($conn) {
    echo "✅ Connected to " . $conn->get_server_info() . "</p>";
} else {
    echo "❌ Failed</p>";
    die();
}

// Check if wholesale_price column exists
echo "<p><strong>Database Structure Check:</strong></p>";
$result = $conn->query("DESCRIBE products");
if ($result) {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Column</th><th>Type</th><th>Null</th><th>Default</th></tr>";
    while ($row = $result->fetch_assoc()) {
        $highlight = ($row['Field'] == 'wholesale_price') ? 'style="background-color: yellow;"' : '';
        echo "<tr $highlight>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Could not check table structure</p>";
}

// Check file timestamp
echo "<p><strong>File Info:</strong></p>";
echo "<p>Current time: " . date('Y-m-d H:i:s') . "</p>";
echo "<p>This file modified: " . date('Y-m-d H:i:s', filemtime(__FILE__)) . "</p>";

if (file_exists('products/products.php')) {
    echo "<p>products.php exists, modified: " . date('Y-m-d H:i:s', filemtime('products/products.php')) . "</p>";
} else {
    echo "<p>❌ products/products.php not found</p>";
}

// Show simple form to test
echo "<hr>";
echo "<h3>Test Form</h3>";
echo '<form method="post">';
echo '<label>Product Name:</label><br>';
echo '<input type="text" name="name" required><br><br>';
echo '<label>Wholesale Price:</label><br>';
echo '<input type="number" step="0.01" name="wholesale_price" required><br><br>';
echo '<label>Selling Price:</label><br>';
echo '<input type="number" step="0.01" name="price" required><br><br>';
echo '<input type="submit" value="Test Submit">';
echo '</form>';

if ($_POST) {
    echo "<h3>Form Data Received:</h3>";
    echo "<pre>";
    print_r($_POST);
    echo "</pre>";
}
?>