<?php
include 'config.php';

echo "=== DATABASE DATA CHECK ===\n\n";

// Test sales table
$result = $conn->query('SELECT COUNT(*) as count, SUM(total_amount) as total FROM sales');
$row = $result->fetch_assoc();
echo 'Sales Table: Count=' . $row['count'] . ', Total=' . $row['total'] . "\n";

// Test products table  
$result = $conn->query('SELECT COUNT(*) as count FROM products');
$row = $result->fetch_assoc();
echo 'Products Table: Count=' . $row['count'] . "\n";

// Test customers table
$result = $conn->query('SELECT COUNT(*) as count FROM customers');
$row = $result->fetch_assoc();
echo 'Customers Table: Count=' . $row['count'] . "\n";

// Test categories table
$result = $conn->query('SELECT COUNT(*) as count FROM categories');
$row = $result->fetch_assoc();
echo 'Categories Table: Count=' . $row['count'] . "\n";

// Test users table
$result = $conn->query('SELECT COUNT(*) as count FROM users');
$row = $result->fetch_assoc();
echo 'Users Table: Count=' . $row['count'] . "\n";

// Test opening_cash table
$result = $conn->query('SELECT COUNT(*) as count FROM opening_cash WHERE cash_date = CURDATE()');
$row = $result->fetch_assoc();
echo 'Opening Cash Today: Count=' . $row['count'] . "\n";

// Show table structure
echo "\n=== TABLE STRUCTURES ===\n\n";

$tables = ['sales', 'products', 'customers', 'categories', 'users'];
foreach ($tables as $table) {
    $result = $conn->query("DESCRIBE $table");
    if ($result) {
        echo "Table: $table\n";
        while ($row = $result->fetch_assoc()) {
            echo "  - " . $row['Field'] . " (" . $row['Type'] . ")\n";
        }
        echo "\n";
    } else {
        echo "ERROR: Table '$table' not found - " . $conn->error . "\n\n";
    }
}
?>
